# Additional Resources

## TensorFlow WhitePapers

Additional details about the TensorFlow programming model and the underlying
implementation can be found in this paper:

* [TensorFlow: A System for Large-Scale Machine Learning](https://www.usenix.org/conference/osdi16/technical-sessions/presentation/abadi)

The original white paper introducing TensorFlow can be found here:

* [TensorFlow: Large-scale machine learning on heterogeneous systems](http://download.tensorflow.org/paper/whitepaper2015.pdf)

A white paper about
@{$tflearn$contrib.learn} is also
available:

* [TF.Learn: TensorFlow's High-level Module for Distributed Machine Learning](https://arxiv.org/abs/1612.04251)

### Citation

If you use TensorFlow in your research and would like to cite the TensorFlow
system, we suggest you cite the paper above.
You can use this @{$bib$BibTeX entry}.  As the project progresses, we
may update the suggested citation with new papers.

Please only use the TensorFlow name and marks when accurately referencing this
software distribution, and do not use our marks in a way that suggests you are
endorsed by or otherwise affiliated with Google. When referring to our marks,
please include the following attribution statement: "TensorFlow, the TensorFlow
logo and any related marks are trademarks of Google Inc."

## What is TensorFlow used for?

TensorFlow enables researchers to build machine learning models. We collect such
models in our [Zoo](https://github.com/tensorflow/models). If you have built a 
model with TensorFlow, you may consider publishing it there.

We keep a list of projects that use TensorFlow @{$uses$here}. If you made
something amazing with TensorFlow, we'd like to hear about it!

## Community

The TensorFlow community has created many great projects around TensorFlow, including:

* [Machine Learning with TensorFlow (Book & Code)](http://tensorflowbook.com)
* [@jtoy's awesome "Awesome TensorFlow" list of awesome things](https://github.com/jtoy/awesome-tensorflow)
* [TensorFlow tutorials](https://github.com/pkmital/tensorflow_tutorials)
* [Scikit Flow - Simplified Interface for TensorFlow](https://github.com/tensorflow/tensorflow/tree/master/tensorflow/contrib/learn/python/learn)
* [Caffe to TensorFlow model converter](https://github.com/ethereon/caffe-tensorflow)
* [Bitfusion's` GPU-enabled AWS EC2 TensorFlow AMI](https://github.com/bitfusionio/amis/tree/master/awsmrkt-bfboost-ubuntu14-cuda75-tensorflow) ([Launch AMI](https://aws.amazon.com/marketplace/pp/B01EYKBEQ0))
* [Rust language bindings](https://github.com/google/tensorflow-rust)
* [Operator Vectorization Library](https://github.com/opveclib/opveclib)

### Development

The source code for TensorFlow is hosted on GitHub:
<https://github.com/tensorflow/tensorflow>.

If you are interested in contributing to TensorFlow please
[review the contributing guide](
https://github.com/tensorflow/tensorflow/blob/master/CONTRIBUTING.md).

### Help / Support / How do I?

For help and support, technical or algorithmic questions, please submit
your questions to Stack Overflow:
<https://stackoverflow.com/questions/tagged/tensorflow>.
You may also find answers in our @{$faq$FAQ}, or
in the @{$dims_types$shapes, sizes and types guide}. Please do not use the
mailing list or issue tracker for support.

### Discussions

For general discussions, please join the
[TensorFlow discuss mailing list](https://groups.google.com/a/tensorflow.org/d/forum/discuss).
This list is intended for general discussions about TensorFlow development and
directions, not as a help forum. Instead, direct your questions to
[Stack Overflow](https://stackoverflow.com/questions/tagged/tensorflow), and
report issues on [GitHub](https://github.com/tensorflow/tensorflow/issues).

### Report Issues

Please report bugs, feature requests and installation / compatibility issues on
the [TensorFlow issues tracker](
https://github.com/tensorflow/tensorflow/issues) on GitHub.
If you need help with using TensorFlow, please do not use the issue
tracker for that. Instead, direct your questions to
[Stack Overflow](https://stackoverflow.com/questions/tagged/tensorflow).

## Versioning

TensorFlow uses [Semantic Versioning 2.0](http://semver.org).  For details on
the versioning of our public API and binary compatibility, see the @{$data_versions$versioning document}.  Additional details for developers are in @{$data_versions$TensorFlow Data Versioning}.
